#define NUM_DRIPS 10

uniform sampler2D texture0;
uniform vec2 textureSize0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform float u_Elapsed;

varying vec4 gl_TexCoord[];
varying highp vec2 v_texCoordRefraction;

//vec2 iResolution = vec2(1.0/textureSize0.x, 1.0/textureSize0.y);
vec2 iResolution = textureSize0;
float Seed;

void srand (float t)
{
    Seed = 0.5 + (sin (t*59.0) + sin (t*73.0) + sin (t*97.0))/6.0;
}
    
float rand()
{
    Seed = 0.25 + 0.5*Seed + 0.25*sin (12345.0 * Seed);
    return Seed;
}

vec2 dripPos (float fTime, out float fAge)
{
    float t = floor (fTime*0.1);
    srand (t);
    fAge = fTime*0.1 - t;
    return vec2 (rand(), rand());
}

void main(void)
{
vec4 vTexCoord = gl_TexCoord[0];
  vec2 vRel = vTexCoord.xy ;//vTexCoord.xy / iResolution.xy;

    float t = u_Elapsed;
    float fStep = 123.456;
    float fHeight = 0.0;
    
    for (int i = 0; i < NUM_DRIPS; i++)
    {
        float fAge;
        vec2 vRnd = dripPos (t, fAge);

        // float fDx = vRel.x - vRnd.x;
        // float fDy = vRel.y - vRnd.y;
        // float fD2 = fDx*fDx + fDy*fDy;
        // float fD = sqrt (fD2);
        
        // the above, simpler:
        vec2 vD = vec2 (vRel - vRnd);
        float fD = sqrt (dot (vD, vD));

        float fDa = 10.0 * (fD - fAge + 0.6);

        fHeight += (1.0 - fAge) 
            * max (0.0, 1.0 - (fDa*fDa))
            * sin (fD*150.0 - fAge*80.0);
        
        t += fStep;
    }

    vRel.y -= sign (fHeight) * fHeight*fHeight;
    vec4 vTex = texture2D (texture0, vRel);

    if (fHeight < 0.0)
    {
        float p = -fHeight*0.8;
        float q = 1.0 - p;
        vTex.b = p + q*vTex.b;
        p = -fHeight*0.3;
        q = 1.0 - p;
        vTex.g = p + q*vTex.g;
    }
    
    gl_FragColor = vTex; 
}